import 'dart:math' as math;
import 'package:flutter/material.dart';
import 'package:flutter_translate/flutter_translate.dart';
import 'package:intl/intl.dart';
import 'package:nexthour/providers/manual_payment_provider.dart';
import '../../providers/gst_provider.dart';
import '../gateways/phonepe_in.dart';
import '../gateways/razor_pay_rent.dart';

import '/common/apipath.dart';
import 'dart:async';
import '/common/global.dart';
import '/common/route_paths.dart';
import '/providers/app_config.dart';

import '/providers/user_profile_provider.dart';

import 'package:provider/provider.dart';

List listPaymentGateways = [];

class RentPaymentScreen extends StatefulWidget {
  RentPaymentScreen(this.movieName, this.movieId, this.price, this.offerPrice,
      this.hours, this.currencyCode, this.type);
  final movieName;
  final movieId;
  final price;
  final offerPrice;
  final hours;
  final currencyCode;
  final type;

  @override
  _RentPaymentScreenState createState() => _RentPaymentScreenState();
}

class _RentPaymentScreenState extends State<RentPaymentScreen>
    with TickerProviderStateMixin, RouteAware {
  final GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();

  ScrollController? _scrollViewController;

  TabController? _paymentTabController;
  bool isDataAvailable = false;
  var refreshKey = GlobalKey<RefreshIndicatorState>();

  bool loading = true;

  PageController hPagerController = PageController(keepPage: true);
  PageController vPagerController = PageController(keepPage: true);
  double mWidth = 100.0;
  double mHeight = 100.0;

  ManualPaymentProvider manualPaymentProvider = ManualPaymentProvider();
  PhonePeCheckoutViewModel? phonePeModel;

  GstProvider? gstProvider;

  @override
  void didChangeDependencies() {
    super.didChangeDependencies();

    // ✅ Access Provider here safely
    gstProvider = Provider.of<GstProvider?>(context, listen: false);
    gstProvider!.fetchGstDetails();
  }

  @override
  void initState() {
    super.initState();

    setState(() {
      loading = true;
    });

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) async {
      gstProvider = Provider.of<GstProvider?>(context, listen: false);
      await gstProvider!.fetchGstDetails();

      listPaymentGateways = [];

      var razorPayPaymentStatus = Provider.of<AppConfig>(context, listen: false)
          .appModel!
          .appConfig!
          .razorpayPayment;

      if (razorPayPaymentStatus == 1 || "$razorPayPaymentStatus" == "1") {
        listPaymentGateways
            .add(PaymentGateInfo(title: 'razorPayment', status: 1));
      }

      setState(() {
        loading = false;
      });
      _paymentTabController = TabController(
          vsync: this,
          length:
              listPaymentGateways.isNotEmpty ? listPaymentGateways.length : 0,
          initialIndex: 0);
    });
  }

  Future<Null> refreshList() async {
    refreshKey.currentState?.show();
    await Future.delayed(Duration(seconds: 2));
  }

//  Apply coupon forward icon
  Widget applyCouponIcon() {
    return Expanded(
      flex: 1,
      child: Padding(
        padding: EdgeInsets.only(left: 0.0),
        child: Icon(
          Icons.keyboard_arrow_right,
        ),
      ),
    );
  }

//  Gift icon
  Widget giftIcon() {
    return Padding(
      padding: EdgeInsets.only(left: 10.0),
      child: Icon(
        Icons.card_giftcard,
        color: Color.fromRGBO(125, 183, 91, 1.0),
      ),
    );
  }

//  Payment method tas
  Widget paymentMethodTabs() {
    return PreferredSize(
      child: SliverAppBar(
        title: TabBar(
          indicatorSize: TabBarIndicatorSize.tab,
          controller: _paymentTabController,
          indicatorColor: activeDotColor,
          isScrollable: true,
          tabs: List<Tab>.generate(
            listPaymentGateways.isEmpty ? 0 : listPaymentGateways.length,
            (int index) {
              if (listPaymentGateways[index].title == 'razorPayment') {
                return Tab(
                  child: tabLabelText('RazorPay'),
                );
              }

              return Tab(
                child: tabLabelText('Default'),
              );
            },
          ),
        ),
        automaticallyImplyLeading: false,
        backgroundColor: Theme.of(context).primaryColorLight,
        pinned: true,
        floating: true,
      ),
      preferredSize: Size.fromHeight(0.0),
    );
  }

//  App bar material design
  Widget appbarMaterialDesign() {
    return Material(
      child: Container(
        height: 80.0,
        decoration: BoxDecoration(
          gradient: LinearGradient(
            // Where the linear gradient begins and ends
            begin: Alignment.centerLeft,
            end: Alignment.centerRight,
            // Add one stop for each color. Stops should increase from 0 to 1
            stops: [0.1, 0.2, 0.4, 0.9],
            colors: [
              Theme.of(context).primaryColor.withValues(alpha: 0.6),
              Theme.of(context).primaryColor.withValues(alpha: 0.7),
              Theme.of(context).primaryColor.withValues(alpha: 0.9),
              Theme.of(context).primaryColor.withValues(alpha: 1.0),
            ],
          ),
        ),
      ),
    );
  }

//  Select payment text
  Widget selectPaymentText() {
    var logo =
        Provider.of<AppConfig>(context, listen: false).appModel!.config!.logo;

    return Row(
      crossAxisAlignment: CrossAxisAlignment.center,
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: <Widget>[
        Padding(
          padding: EdgeInsets.only(left: 20.0, top: 40.0),
        ),
        Expanded(
          flex: 1,
          child: Text(
            translate('Select_Payment'),
            style: TextStyle(
              fontSize: 18.0,
              fontWeight: FontWeight.w800,
            ),
          ),
        ),
        Expanded(
          flex: 1,
          child: Container(
            padding: EdgeInsets.only(left: 40.0, right: 20.0),
            child: Image.network('${APIData.logoImageUri}$logo'),
          ),
        )
      ],
    );
  }

//  Plan name and user name
  Widget planAndUserName() {
    var name =
        Provider.of<UserProfileProvider>(context).userProfileModel!.user!.name!;
    return Expanded(
        flex: 2,
        child: Padding(
          padding: EdgeInsets.fromLTRB(0.0, 10.0, 0.0, 0.0),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Padding(
                padding: EdgeInsets.only(left: 20.0),
              ),
              Expanded(
                flex: 2,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      "${widget.movieName}",
                      style: TextStyle(
                          color: Color.fromRGBO(72, 163, 198, 1.0),
                          fontSize: 14.0,
                          fontWeight: FontWeight.w600),
                    ),
                    Padding(
                      padding: EdgeInsets.only(top: 15.0),
                    ),
                    Text(
                      name,
                      style: TextStyle(
                        fontSize: 12.0,
                        height: 1.3,
                      ),
                    ),
                  ],
                ),
              ),
            ],
          ),
        ));
  }

//  Minimum duration
  Widget minDuration() {
    // var planDetails = Provider.of<AppConfig>(context).planList;
    return Expanded(
      flex: 2,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.start,
        children: <Widget>[
          Text(
            'Total duration ' + '${widget.hours}' + ' hr',
            style: TextStyle(
              fontSize: 12.0,
              height: 1.3,
            ),
          ),
          Padding(
            padding: EdgeInsets.only(top: 10.0),
          ),
          Text(
            new DateFormat.yMMMd().format(new DateTime.now()),
            style: TextStyle(
              fontSize: 12.0,
              height: 1.5,
            ),
          ),
        ],
      ),
    );
  }

  dynamic customRound(double val, int places) {
    num mod = math.pow(10.0, places);
    var v = ((val * mod).round().toDouble() / mod).toStringAsFixed(places);
    return int.parse(v);
  }

//  After applying coupon
  Widget couponProcessing(afterDiscountAmount, indexPer) {
    return Container(
      margin: EdgeInsets.fromLTRB(20.0, 10.0, 20, 0.0),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          Row(
            // crossAxisAlignment: CrossAxisAlignment.stretch,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: <Widget>[
              discountText(),
              Flexible(
                  flex: 1,
                  child:
                      // validCoupon == true && percentOFF != null
                      //     ?
                      Text(
                    widget.price + " %",
                    style: TextStyle(
                      fontSize: 12.0,
                      height: 1.3,
                    ),
                  )
                  // : amountOFF != null
                  //     ? Text(
                  //         amountOFF.toString() +
                  //             " currency",
                  //         style: TextStyle(
                  //           fontSize: 12.0,
                  //           height: 1.3,
                  //         ),
                  //       )
                  //     : Text(
                  //         "0 %",
                  //         style: TextStyle(
                  //           fontSize: 12.0,
                  //           height: 1.3,
                  //         ),
                  //       ),
                  ),
            ],
          ),
          SizedBox(
            height: 10.0,
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: <Widget>[
              afterDiscountText(),
              // validCoupon == true
              //     ? Text(
              //         "${customRound(afterDiscountAmount, 0)}" +
              //             ".00"
              //                 " ${currency(planDetails[widget.planIndex].currency)}",
              //         style: TextStyle(
              //           fontSize: 12.0,
              //           height: 1.3,
              //         ),
              //       )
              //     : amountText(indexPer),
            ],
          )
        ],
      ),
    );
  }

//  Plan amount
  Widget planAmountText() {
    var gstPer = 0;
    if (gstProvider!.gstModel!.gst![0].gstPer != null) {
      gstPer = int.parse(gstProvider!.gstModel!.gst![0].gstPer!);
    } else {
      gstPer = 0;
    }
    var finalAmount = 0.0;
    if (gstProvider!.gstModel!.gst![0].gstEnable == 1 ||
        gstProvider!.gstModel!.gst![0].gstEnable == '1') {
      if (widget.offerPrice == null) {
        finalAmount = ((gstPer / 100) * int.parse(widget.price)) +
            int.parse(widget.price);
      } else {
        finalAmount = ((gstPer / 100) * int.parse(widget.offerPrice)) +
            int.parse(widget.offerPrice);
      }
    } else {
      if (widget.offerPrice == null) {
        finalAmount =
            ((0.0) * int.parse(widget.price)) + int.parse(widget.price);
      } else {
        finalAmount = ((0.0) * int.parse(widget.offerPrice)) +
            int.parse(widget.offerPrice);
      }
    }

    return Padding(
        padding: EdgeInsets.only(right: 15),
        child: widget.offerPrice == null
            ? RichText(
                textAlign: TextAlign.right,
                text: new TextSpan(
                  text: 'Total amount  \n',
                  style:
                      TextStyle(fontSize: 14, color: Colors.white, height: 1.2),
                  children: <TextSpan>[
                    new TextSpan(
                        text:
                            ' ${currency(widget.currencyCode)} ${widget.price}',
                        style: TextStyle(
                            fontSize: 20,
                            color: Colors.white,
                            fontWeight: FontWeight.bold)),
                    gstProvider!.gstModel!.gst![0].gstEnable == 1 ||
                            gstProvider!.gstModel!.gst![0].gstEnable == '1'
                        ? new TextSpan(
                            text: 'GST:  ',
                            style: TextStyle(
                                fontSize: 16,
                                color: Colors.white,
                                fontWeight: FontWeight.normal))
                        : new TextSpan(
                            text: '',
                            style: TextStyle(
                                fontSize: 16,
                                color: Colors.white,
                                fontWeight: FontWeight.normal)),
                    gstProvider!.gstModel!.gst![0].gstEnable == 1 ||
                            gstProvider!.gstModel!.gst![0].gstEnable == '1'
                        ? new TextSpan(
                            text:
                                '${gstProvider!.gstModel!.gst![0].gstPer}% \n\n',
                            style: TextStyle(
                                fontSize: 18,
                                color: Colors.white,
                                fontWeight: FontWeight.bold))
                        : new TextSpan(
                            text: '',
                            style: TextStyle(
                                fontSize: 18,
                                color: Colors.white,
                                fontWeight: FontWeight.bold)),
                    gstProvider!.gstModel!.gst![0].gstEnable == 1 ||
                            gstProvider!.gstModel!.gst![0].gstEnable == '1'
                        ? new TextSpan(
                            text: '\nInclusive of all Taxes:  ',
                            style: TextStyle(
                                fontSize: 14,
                                color: Colors.white,
                                fontWeight: FontWeight.normal))
                        : new TextSpan(
                            text: '',
                            style: TextStyle(
                                fontSize: 14,
                                color: Colors.white,
                                fontWeight: FontWeight.normal)),
                    gstProvider!.gstModel!.gst![0].gstEnable == 1 ||
                            gstProvider!.gstModel!.gst![0].gstEnable == '1'
                        ? new TextSpan(
                            text:
                                ' ${currency(widget.currencyCode)} ${finalAmount.toStringAsFixed(0)}',
                            style: TextStyle(
                                fontSize: 20,
                                color: Colors.white,
                                fontWeight: FontWeight.bold))
                        : new TextSpan(
                            text: '',
                            style: TextStyle(
                                fontSize: 20,
                                color: Colors.white,
                                fontWeight: FontWeight.bold)),
                  ],
                ),
              )
            : RichText(
                textAlign: TextAlign.right,
                text: new TextSpan(
                  text: 'Total amount  \n',
                  style:
                      TextStyle(fontSize: 14, color: Colors.white, height: 1.2),
                  children: <TextSpan>[
                    new TextSpan(
                      text: '${currency(widget.currencyCode)}${widget.price}',
                      style: new TextStyle(
                        color: Colors.white.withValues(alpha: 0.6),
                        fontSize: 14,
                        decoration: TextDecoration.lineThrough,
                      ),
                    ),
                    new TextSpan(
                        text:
                            ' ${currency(widget.currencyCode)} ${widget.offerPrice}\n',
                        style: TextStyle(
                            fontSize: 20,
                            color: Colors.white,
                            fontWeight: FontWeight.bold)),
                    gstProvider!.gstModel!.gst![0].gstEnable == 1 ||
                            gstProvider!.gstModel!.gst![0].gstEnable == '1'
                        ? new TextSpan(
                            text: 'GST:  ',
                            style: TextStyle(
                                fontSize: 16,
                                color: Colors.white,
                                fontWeight: FontWeight.normal))
                        : new TextSpan(
                            text: '',
                            style: TextStyle(
                                fontSize: 16,
                                color: Colors.white,
                                fontWeight: FontWeight.normal)),
                    gstProvider!.gstModel!.gst![0].gstEnable == 1 ||
                            gstProvider!.gstModel!.gst![0].gstEnable == '1'
                        ? new TextSpan(
                            text:
                                '${gstProvider!.gstModel!.gst![0].gstPer}% \n\n',
                            style: TextStyle(
                                fontSize: 18,
                                color: Colors.white,
                                fontWeight: FontWeight.bold))
                        : new TextSpan(
                            text: '',
                            style: TextStyle(
                                fontSize: 18,
                                color: Colors.white,
                                fontWeight: FontWeight.bold)),
                    gstProvider!.gstModel!.gst![0].gstEnable == 1 ||
                            gstProvider!.gstModel!.gst![0].gstEnable == '1'
                        ? new TextSpan(
                            text: 'Inclusive of all Taxes:  ',
                            style: TextStyle(
                                fontSize: 14,
                                color: Colors.white,
                                fontWeight: FontWeight.normal))
                        : new TextSpan(
                            text: '',
                            style: TextStyle(
                                fontSize: 14,
                                color: Colors.white,
                                fontWeight: FontWeight.normal)),
                    gstProvider!.gstModel!.gst![0].gstEnable == 1 ||
                            gstProvider!.gstModel!.gst![0].gstEnable == '1'
                        ? new TextSpan(
                            text:
                                ' ${currency(widget.currencyCode)} ${finalAmount.toStringAsFixed(0)}',
                            style: TextStyle(
                                fontSize: 20,
                                color: Colors.white,
                                fontWeight: FontWeight.bold))
                        : new TextSpan(
                            text: '',
                            style: TextStyle(
                                fontSize: 20,
                                color: Colors.white,
                                fontWeight: FontWeight.bold)),
                  ],
                ),
              ));
  }

//  Logo row
  Widget logoRow() {
    var logo =
        Provider.of<AppConfig>(context, listen: false).appModel!.config!.logo;
    return Row(
      crossAxisAlignment: CrossAxisAlignment.center,
      mainAxisAlignment: MainAxisAlignment.end,
      children: <Widget>[
        Container(
          margin: EdgeInsets.only(top: 12.0, right: 12.0),
          alignment: Alignment.center,
          child: Image.network(
            '${APIData.logoImageUri}$logo',
            scale: 1.9,
          ),
        ),
      ],
    );
  }

//  Discount percent
  Widget discountText() {
    return Expanded(
      flex: 5,
      child: Text(
        translate("Discount_"),
        style: TextStyle(
          fontSize: 12.0,
          height: 1.3,
        ),
      ),
    );
  }

//  Amount after discount
  Widget afterDiscountText() {
    return Expanded(
      flex: 4,
      child: Text(
        translate("After_Discount_Amount_"),
        style: TextStyle(
          fontSize: 12.0,
          height: 1.3,
        ),
      ),
    );
  }

  String currency(code) {
    var format = NumberFormat.simpleCurrency(
      name: code, //currencyCode
    );
    print("CURRENCY SYMBOL ${format.currencySymbol}"); // $
    print("CURRENCY NAME ${format.currencyName}"); // USD
    return "${format.currencySymbol}";
  }

//  Amount
  Widget amountText(indexPer) {
    var planDetails = Provider.of<AppConfig>(context).planList;
    return Text(
      "${planDetails[indexPer].amount}" +
          " ${currency(planDetails[indexPer].currency)}",
      style: TextStyle(
        fontSize: 12.0,
        height: 1.3,
      ),
    );
  }

//  Tab label text
  Widget tabLabelText(label) {
    return Container(
      alignment: Alignment.center,
      padding: EdgeInsets.only(left: 5.0, right: 5.0),
      child: new Text(
        label,
        style: TextStyle(
          fontFamily: 'Lato',
          fontSize: 13.0,
          fontWeight: FontWeight.w800,
          letterSpacing: 0.9,
        ),
      ),
    );
  }

// Swipe down row
  Widget swipeDownRow() {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.center,
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        SizedBox(
          height: 100.0,
        ),
        swipeIconContainer(),
        SizedBox(
          width: 10.0,
        ),
        swipeDownText(),
      ],
    );
  }

// Swipe icon container
  Widget swipeIconContainer() {
    return Container(
      height: 25.0,
      width: 25.0,
      decoration: BoxDecoration(
        border: Border.all(
          width: 2.0,
          color: Color.fromRGBO(125, 183, 91, 1.0),
        ),
        shape: BoxShape.circle,
        color: Theme.of(context).colorScheme.background,
      ),
      child: Icon(
        Icons.keyboard_arrow_down,
        size: 21.0,
      ),
    );
  }

//  Swipe down text
  Widget swipeDownText() {
    return Text(
      translate("Swipe_down_wallet_to_pay"),
      style: TextStyle(
        fontSize: 16.0,
      ),
    );
  }

  // Razorpay Payment wallet
  Widget razorPaymentWallet() {
    var gstPer = 0;

    if (gstProvider!.gstModel!.gst![0].gstPer != null) {
      gstPer = int.parse(gstProvider!.gstModel!.gst![0].gstPer!);
    } else {
      gstPer = 0;
    }

    var finalAmount = 0.0;
    if (gstProvider!.gstModel!.gst![0].gstEnable == 1 ||
        gstProvider!.gstModel!.gst![0].gstEnable == '1') {
      if (widget.offerPrice == null) {
        finalAmount = ((gstPer / 100) * int.parse(widget.price)) +
            int.parse(widget.price);
      } else {
        finalAmount = ((gstPer / 100) * int.parse(widget.offerPrice)) +
            int.parse(widget.offerPrice);
      }
    } else {
      if (widget.offerPrice == null) {
        finalAmount =
            ((0.0) * int.parse(widget.price)) + int.parse(widget.price);
      } else {
        finalAmount = ((0.0) * int.parse(widget.offerPrice)) +
            int.parse(widget.offerPrice);
      }
    }
    return Container(
      width: double.infinity,
      height: double.infinity,
      color: Theme.of(context).colorScheme.background,
      child: SingleChildScrollView(
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.center,
          mainAxisSize: MainAxisSize.min,
          children: <Widget>[
            Padding(padding: EdgeInsets.fromLTRB(0.0, 50.0, 0.0, 0.0)),
            swipeDownRow(),
            Dismissible(
                direction: DismissDirection.down,
                key: Key("0"),
                confirmDismiss: (direction) async {
                  if (direction == DismissDirection.startToEnd) {
                    return false;
                  } else if (direction == DismissDirection.endToStart) {
                    return true;
                  }

                  Navigator.pushNamed(
                    context,
                    RoutePaths.razorpayRrnt,
                    arguments: RazorPaymentRent(
                        widget.movieId,
                        widget.movieName,
                        widget.price,
                        widget.offerPrice,
                        finalAmount.toStringAsFixed(0),
                        widget.currencyCode,
                        widget.type),
                  );

                  return null;
                },
                child: Padding(
                  padding: EdgeInsets.fromLTRB(120.0, 0.0, 100.0, 0.0),
                  child: Image.asset("assets/razorpay.png"),
                )),
          ],
        ),
      ),
    );
  }

  //  Sliver List
  Widget _sliverList() {
    return SliverList(
      delegate: SliverChildBuilderDelegate(
        (BuildContext context, int j) {
          return Container(
            child: Column(
              children: <Widget>[
                new Container(
                  child: Column(
                    children: <Widget>[
                      Stack(
                        children: <Widget>[
                          appbarMaterialDesign(),
                          Container(
                            margin: EdgeInsets.only(top: 60.0),
                            decoration: BoxDecoration(
                              color: Theme.of(context).primaryColorLight,
                              borderRadius: BorderRadius.only(
                                  topLeft: Radius.circular(20.0),
                                  topRight: Radius.circular(20.0)),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: <Widget>[
                                AspectRatio(
                                  aspectRatio: 16.0 / 10.5,
                                  child: Column(
                                    children: <Widget>[
                                      Padding(
                                        padding: EdgeInsets.fromLTRB(
                                            0.0, 10.0, 0.0, 0.0),
                                      ),
                                      selectPaymentText(),
                                      Padding(
                                        padding: EdgeInsets.fromLTRB(
                                            0.0, 10.0, 0.0, 0.0),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          mainAxisAlignment:
                                              MainAxisAlignment.start,
                                          children: <Widget>[
                                            // Padding(
                                            //   padding:
                                            //       EdgeInsets.only(left: 20.0),
                                            // ),
                                            planAndUserName(),
                                            planAmountText(),
                                          ],
                                        ),
                                      ),
                                      Padding(
                                        padding: EdgeInsets.fromLTRB(
                                            0.0, 10.0, 0.0, 0.0),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          mainAxisAlignment:
                                              MainAxisAlignment.start,
                                          children: <Widget>[
                                            Padding(
                                              padding:
                                                  EdgeInsets.only(left: 20.0),
                                            ),
                                            minDuration(),
                                          ],
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ),
                          new Positioned(
                            top: 8.0,
                            left: 4.0,
                            child: new BackButton(color: Colors.white),
                          ),
                        ],
                      ),
                    ],
                  ),
                ),
              ],
            ),
          );
        },
        addAutomaticKeepAlives: true,
        addRepaintBoundaries: true,
        addSemanticIndexes: true,
        childCount: 1,
      ),
    );
  }

  //  Scaffold body
  Widget _scaffoldBody() {
    return NestedScrollView(
      physics: ClampingScrollPhysics(),
      controller: _scrollViewController,
      headerSliverBuilder: (BuildContext context, bool innerBoxIsScrolled) {
        return <Widget>[
          _sliverList(),
          paymentMethodTabs(),
        ];
      },
      body: _nestedScrollViewBody(),
    );
  }

  // NestedScrollView body
  Widget _nestedScrollViewBody() {
    return listPaymentGateways.length == 0
        ? Center(
            child: Text(translate("No_payment_method_available")),
          )
        : listPaymentGateways.length == 1
            ? Center(
                child: razorPaymentWallet(),
              )
            : TabBarView(
                controller: _paymentTabController,
                physics: PageScrollPhysics(),
                children: List<Widget>.generate(
                    listPaymentGateways.isEmpty
                        ? 0
                        : listPaymentGateways.length, (int index) {
                  // if (listPaymentGateways[index].title == 'PayU') {
                  //   return InkWell(
                  //     child: payu(widget.planIndex),
                  //   );
                  // }

                  // if (listPaymentGateways[index].title == 'InstaMojo') {
                  //   return InkWell(
                  //     child: instamojo(widget.planIndex),
                  //   );
                  // }
                  // if (listPaymentGateways[index].title == 'btree') {
                  //   return InkWell(
                  //     child: braintreePayment(widget.planIndex),
                  //   );
                  // }
                  // if (listPaymentGateways[index].title == 'stripe') {
                  //   return InkWell(
                  //     child: stripePaymentWallet(widget.planIndex),
                  //   );
                  // }
                  // if (listPaymentGateways[index].title == 'paystack') {
                  //   return InkWell(
                  //     child: paystackPaymentWallet(widget.planIndex),
                  //   );
                  // }
                  // if (listPaymentGateways[index].title == 'bankPayment') {
                  //   return InkWell(
                  //     child: bankPaymentWallet(widget.planIndex),
                  //   );
                  // }
                  if (listPaymentGateways[index].title == 'razorPayment') {
                    return InkWell(
                      child: razorPaymentWallet(),
                    );
                  }
                  // if (listPaymentGateways[index].title == 'paytmPayment') {
                  //   return InkWell(
                  //     child: paytmPaymentWallet(widget.planIndex),
                  //   );
                  // }
                  // if (listPaymentGateways[index].title == 'paypalPayment') {
                  //   return InkWell(
                  //     child: paypalPayment(widget.planIndex),
                  //   );
                  // }
                  // if (listPaymentGateways[index].title == 'inapp') {
                  //   return InkWell(
                  //     child: inappPayment(widget.planIndex),
                  //   );
                  // }
                  // // Manual Payment
                  // if (listPaymentGateways[index].title == 'manualPayment') {
                  //   return InkWell(
                  //     child: manualPayment(widget.planIndex),
                  //   );
                  // }

                  // // Rave Payment
                  // if (listPaymentGateways[index].title == 'ravePayment') {
                  //   return InkWell(
                  //     child: ravePayment(widget.planIndex),
                  //   );
                  // }
                  // // Payhere Payment
                  // if (listPaymentGateways[index].title == 'payherePayment') {
                  //   return InkWell(
                  //     child: payherePayment(widget.planIndex),
                  //   );
                  // }
                  // // UPI Payment
                  // if (listPaymentGateways[index].title == 'upiPayment') {
                  //   return InkWell(
                  //     child: upiPayment(widget.planIndex),
                  //   );
                  // }
                  return widget;
                }));
  }

  void setState_() {
    setState(() {});
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: PopScope(
        child: DefaultTabController(
          length: 2,
          child: Scaffold(
            key: _scaffoldKey,
            body: loading == true
                ? Center(
                    child: CircularProgressIndicator(
                      valueColor: new AlwaysStoppedAnimation<Color>(
                          Theme.of(context).primaryColor),
                    ),
                  )
                : _scaffoldBody(),
          ),
        ),
        canPop: true,
        onPopInvoked: (didPop) {
          if (didPop) {
            return;
          }
        },
      ),
    );
  }
}

class PaymentGateInfo {
  String? title;
  dynamic status;

  PaymentGateInfo({this.title, this.status});
}
